
function JTreeNode2(owner, parent, type, name, caption, expanded, loaded)
{
	var self = this;

	this.initialize(owner, parent, name, caption);

	this.type     = new Number(type);
	this.expanded = utils.parseBool(expanded);
	this.loaded   = utils.parseBool(loaded);
	this.last     = null;
	this.methods  = (cmNone);

	var prnt = this.owner.getObject(this.parent);
	if ((this.type == ntRoot) && (prnt != null) && (prnt.root == null))
		prnt.root = this;
}


function JTreeView2(owner, parent, name, rect, tab)
{
	var self = this;
	this.initialize(owner, parent, name, null, null, rect);

	this.root      = null;
	this.textColor = "#002587";
	this.linkColor = "#FF0000";
	this.textFont  = "Verdana";
	this.textSize  = "8pt";
	this.methods   = (cmRender | cmLoad);
	this.tab       = tab;

	this.render       = render;
	this.load         = load;
	this.renderBranch = renderBranch;
	this.showBranch   = showBranch;
	this.toggle       = toggle;
	this.click        = click;
	this.dispose      = dispose;

	/* Cached images */
	this.owner.addImage("blank",         "img-blank.gif", "tree");
	this.owner.addImage("branch-cont",   "img-branch-cont-0.gif", "tree");
	this.owner.addImage("branch-end",    "img-branch-end-0.gif", "tree");
	this.owner.addImage("folder-closed", "img-folder-closed-0.gif", "tree");
	this.owner.addImage("folder-open",   "img-folder-open-0.gif", "tree");
	this.owner.addImage("link",          "img-page.gif", "tree");
	this.owner.addImage("minus-cont",    "img-minus-cont-0.gif", "tree");
	this.owner.addImage("minus-end",     "img-minus-end-0.gif", "tree");
	this.owner.addImage("plus-cont",     "img-plus-cont-0.gif", "tree");
	this.owner.addImage("plus-end",      "img-plus-end-0.gif", "tree");
	this.owner.addImage("root",          "img-globe-0.gif", "tree");
	this.owner.addImage("vert-line",     "img-vert-line-0.gif", "tree");

	function render(fs)
	{
		fs.append('<div class="treeview" id="' + self.name  + '" style="' + self.rect + '">');
		fs.append('<table id="' + self.name + '_table" border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse">');
		fs.append('</table>');
		fs.append('</div>');
	}

	function load()
	{
		self.renderBranch("", self.root, self.root.expanded);
	}
  
	function renderBranch(prefix, root, visible)
	{
		var doc = self.owner.getDocument();
		var lines = self.owner.$(self.name + '_table');
		if ((lines.firstChild != null) && (lines.firstChild.tagName.toLowerCase() == 'tbody'))
			lines = lines.firstChild;

		var row     = null;
		var cell    = null;
		var style   = "font-family: " + self.textFont + "; font-size: " + self.textSize + "; color: " + self.textColor + "; ";
		var last    = false;
		var onClick = "";
		var html    = "";

		if (root.type == ntRoot)
		{
			row = doc.createElement("tr");
			row.id  = root.name + "#tr";
			lines.appendChild(row);

			cell = doc.createElement("td");
			cell.noWrap = true;
			row.appendChild(cell);

			onClick = self.objectName + ".toggle('" + root.name + "'); return ( false );";
			html    = '<span id="' + root.name + '" class="treeNode">' + prefix + '<a class="treeNode" href="" onclick="' + onClick + '" style="' + style + '"><img src="' + self.owner.images['root'].src + '" border="0" align="texttop">&nbsp;' + root.caption + '</a></span>\n';

			cell.innerHTML = html;
		}
  
		var i         = 0;
		var node      = null;
		var sign      = "";
		var icons     = "";
		var children  = root.controls;
		for (var ii = 0; ii < children.length; ii++)
		{
			last = (i == (children.length - 1));
			node = children[ii];

			row = doc.createElement("tr");
			row.id = node.name + "#tr";
			lines.appendChild(row);

			cell = doc.createElement("td");
			cell.noWrap = true;
			row.appendChild(cell);

			if (visible == false)
				row.style.display = 'none';

			if (node.type == ntFolder)
			{
				node.last = last;
				onClick   = self.objectName + ".toggle('" + node.name + "'); return ( false );";
				sign      = (node.expanded == true) ? "minus" : "plus";
				icons     = '<img id="' + node.name + '#sign" src="' + self.owner.images[sign + (!last ? '-cont' : '-end')].src + '" border="0" align="texttop" />';
				html      = '<span id="' + node.name + '" class="treeNode">' + prefix + '<a class="treeNode" href="" onclick="' + onClick + '" style="' + style + '">' + icons + '<img id="' + node.name + '#folder" src="' + self.owner.images[(node.expanded == true) ? 'folder-open' : 'folder-closed'].src + '" border="0" align="texttop">&nbsp;' + node.caption + '</a></span>\n';

				if (visible == true)
					cell.innerHTML = html;
				else
					cell.backupHTML = html;

				self.renderBranch(prefix + '<img src="' + self.owner.images[!last ? 'vert-line' : 'blank'].src + '" border="0" align="texttop" />', node, (node.expanded == true) && visible);
			}

			if (node.type == ntLeaf)
			{
				onClick = self.objectName + ".click('" + node.name + "'); return ( false );";
				icons   = '<img src="' + self.owner.images['branch-' + (!last ? 'cont' : 'end')].src + '" border="0" align="texttop" />';
				html    = '<span id="' + node.name + '" class="treeNode">' + prefix + icons + '<a class="treeNode" href="" onclick="' + onClick + '" style="' + style + '"><img src="' + self.owner.images['link'].src + '" border="0" align="texttop" />&nbsp;' + node.caption + '</a></span>\n';

				if (visible == true)
					cell.innerHTML = html;
				else
					cell.backupHTML = html;
			}
			i++;
		}
	}
  
	function showBranch(root, visible)
	{
		var row = null;
		var children = root.controls;
		for (var i = 0; i < children.length; i++)
		{
			var child = children[i];
			row = self.owner.$(child.name + '#tr');
			if (visible == true)
			{
				if (row.cells[0].innerHTML == "")
				{
					row.cells[0].innerHTML  = row.cells[0].backupHTML;
					row.cells[0].backupHTML = null;
				}
				row.style.display = '';
			}
			else
			{
				row.style.display = 'none';
			}
			child.visible = visible;

			if ((child.type == ntFolder) && (child.expanded == true))
				self.showBranch(child, (child.expanded == true) && visible);
		}
	}
  
	function toggle(nodeName)
	{
		var node = self.owner.getObject(nodeName);
		var img_sgn   = self.owner.$(nodeName + '#sign');
		var img_fld   = self.owner.$(nodeName + '#folder');

		node.expanded = (node.expanded == true) ? false : true;
		if ((img_sgn != null) && (img_fld != null))
		{
			img_sgn.src = self.owner.images[((node.expanded == true) ? 'minus' : 'plus') + '-' + (!node.last ? 'cont' : 'end')].src;
			img_fld.src = self.owner.images["folder-" + ((node.expanded == true) ? 'open' : 'closed')].src;
		}
		self.showBranch(node, node.expanded);
	}
  
	function click(nodeName)
	{
		if (!self.owner.canPerformAction(raClickMenuTree))
			return;

		var query = new Postback(raClickMenuTree);
		query.set('row', nodeName.split('#')[1]);
		self.owner.post(raClickMenuTree, query);
		query = null;
	}

	function dispose()
	{
		var elems = self.$$().getElementsByTagName("A");
		for (var i = 0; i < elems.length; i++)
		{
			elems[i].onclick = null;
		}

		self.disposeChildren();
		self.base.dispose.call(self);
	}

}

JTreeView2.inheritsFrom(ControlBase);
JTreeNode2.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();